	function [Num11, Num12, Num21, Num22, Den] = S_MULT(NumA11, NumA12, NumA21, NumA22, DenA, NumB11, NumB12, NumB21, NumB22, DenB)
	
	%	Multiplies the scattering matrices SA and SB, where the numerators and 
	%	denominatoers are represented by polynomials.
	%
	%	S = (A12*B21+A11*B11, A12*B22+A11*B12; A22*B21+A21*B11, A22*B22+A21*B12)
	
	% 	Toolbox for ANALOG FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2009-10-09
	% Modified by: 	 	
	% Copyright:		by authors - not released for commercial use
	% Version:			1  
	% Known bugs: 
	% Report bugs to:	Wanhammar@gmail.com
	
	%	Den =  POLYMULT(DenA, DenB);
	Den = 1;
	Num11 = POLYADD(POLYMULT(NumA12, NumB21), POLYMULT(NumA11, NumB11));
	Num12 = POLYADD(POLYMULT(NumA12, NumB22), POLYMULT(NumA11, NumB12));
	Num21 = POLYADD(POLYMULT(NumA22, NumB21), POLYMULT(NumA21, NumB11));
	Num22 = POLYADD(POLYMULT(NumA22, NumB22), POLYMULT(NumA21, NumB12));
	
